<?php

namespace App\Http\Controllers;

use App\Models\PaymentType;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class TransactionController extends Controller
{
    public function fetchTransaction()
    {
        $id = Auth::guard('customer')->user()->id;
        $transactions = DB::table('transactions')->where("payable_id", $id)->latest()->get();
        return response()->json([
            'success' => true,
            'message' => 'Transactions fetch successfully',
            'transactions' => $transactions,
        ], 201);
    }
}
