<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customer_investments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('customer_id');
            $table->unsignedBigInteger('investment_id');
            $table->decimal('amount', 15, 2); // supports large amounts with 2 decimal places
            $table->unsignedBigInteger('start_seconds'); // Unix timestamp in seconds
            $table->unsignedBigInteger('end_seconds');   // Unix timestamp in seconds
            $table->string('status')->default('active'); // e.g., 'active', 'completed', 'cancelled'
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customer_investments');
    }
};
