<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CustomerAuthController;
use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\PaymentTypeController;
use App\Http\Controllers\FundingTransactionController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\InvestmentController;

// Handle all OPTIONS requests for CORS preflight


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

// Add CORS headers to your API routes
Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');


Route::prefix('admin')->group(function () {
    Route::post('register', [AdminAuthController::class, 'register']);
    Route::post('login', [AdminAuthController::class, 'login']);

    Route::middleware('auth:admin')->group(function () {
        Route::get('profile', [AdminAuthController::class, 'profile']);
        Route::put('profile', [AdminAuthController::class, 'updateProfile']);
        Route::post('change-password', [AdminAuthController::class, 'changePassword']);
        Route::post('refresh', [AdminAuthController::class, 'refresh']);
        Route::post('logout', [AdminAuthController::class, 'logout']);

        // RESTful routes for PaymentType
        Route::apiResource('payment-types', PaymentTypeController::class);
        Route::prefix('payment-types')->group(function () {
            Route::get('active', [PaymentTypeController::class, 'active']);
            Route::get('type/{type}', [PaymentTypeController::class, 'byType']);
            Route::patch('{paymentType}/activate', [PaymentTypeController::class, 'activate']);
            Route::patch('{paymentType}/deactivate', [PaymentTypeController::class, 'deactivate']);
        });

        Route::prefix('customers')->group(function () {
            Route::get('list', [AdminAuthController::class, 'indexList']);
            Route::get('{id}', [AdminAuthController::class, 'singleCustomer']);
        });


        Route::prefix('funding-transaction')->group(function () {
            Route::get('list', [FundingTransactionController::class, 'index']);
            Route::post('confirm-funding/{fundingTransaction}', [FundingTransactionController::class, 'confirmFunding']);
        });
    });



    Route::prefix('investments')->group(function () {
        // Standard CRUD routes
        Route::get('/', [InvestmentController::class, 'index']); // GET /investments
        Route::post('/', [InvestmentController::class, 'store']); // POST /investments
        Route::get('/{investment}', [InvestmentController::class, 'show']); // GET /investments/{id}
        Route::put('/{investment}', [InvestmentController::class, 'update']); // PUT /investments/{id}
        Route::patch('/{investment}', [InvestmentController::class, 'update']); // PATCH /investments/{id}
        Route::delete('/{investment}', [InvestmentController::class, 'destroy']); // DELETE /investments/{id}

        // Additional routes for soft delete functionality
        Route::post('/{id}/restore', [InvestmentController::class, 'restore']); // POST /investments/{id}/restore
        Route::delete('/{id}/force-delete', [InvestmentController::class, 'forceDelete']); // DELETE /investments/{id}/force-delete

        // Utility routes
        Route::get('/active/list', [InvestmentController::class, 'active']); // GET /investments/active/list
        Route::patch('/{investment}/toggle-status', [InvestmentController::class, 'toggleStatus']); // PATCH /investments/{id}/toggle-status
        Route::post('/{investment}/validate-amount', [InvestmentController::class, 'validateAmount']); // POST /investments/{id}/validate-amount
    });
});

// Customer Authentication Routes
Route::group(['prefix' => 'customer'], function () {
    Route::post('register', [CustomerAuthController::class, 'register']);
    Route::post('login', [CustomerAuthController::class, 'login']);
    Route::post('forgot-password', [CustomerAuthController::class, 'forgotPassword']);
    Route::post('reset-password', [CustomerAuthController::class, 'resetPassword']);
    Route::post('verify-reset-token', [CustomerAuthController::class, 'verifyResetToken']);

    Route::prefix('investments')->group(function () {
        // Standard CRUD routes
        Route::get('/', [InvestmentController::class, 'index']); // GET /investments
        Route::post('/join-investment', [InvestmentController::class, 'joinInvestment'])->middleware(['auth:customer']); // POST /investments
        Route::get('/customer-investment-list', [InvestmentController::class, 'customerInvestmentList'])->middleware(['auth:customer']); // POST /investments
        // Route::put('/{investment}', [InvestmentController::class, 'update']); // PUT /investments/{id}
        // Route::patch('/{investment}', [InvestmentController::class, 'update']); // PATCH /investments/{id}
        // Route::delete('/{investment}', [InvestmentController::class, 'destroy']); // DELETE /investments/{id}
        Route::get('/{customerInvestment}', [InvestmentController::class, 'showCustomerInvestment']); // GET /investments/{id}
    });

    Route::middleware('auth:customer')->group(function () {
        Route::get('profile', [CustomerAuthController::class, 'profile']);
        Route::put('profile', [CustomerAuthController::class, 'updateProfile']);
        Route::post('change-password', [CustomerAuthController::class, 'changePassword']);
        Route::post('logout', [CustomerAuthController::class, 'logout']);
        Route::post('refresh', [CustomerAuthController::class, 'refresh']);

        Route::prefix('funding-transaction')->group(function () {
            Route::post('submit', [FundingTransactionController::class, 'store']);
            Route::get('list', [FundingTransactionController::class, 'index']);
            Route::post('prove-image-url/{fundingTransaction}', [FundingTransactionController::class, 'proveImageUrl']);
        });


        // Route::apiResource('payment-types', PaymentTypeController::class);
        Route::prefix('payment-types')->group(function () {
            Route::get('', [PaymentTypeController::class, 'index']);
            Route::get('customer-list', [PaymentTypeController::class, 'customerPaymentTypelist']);
            Route::post('submit-customer-list', [PaymentTypeController::class, 'submitPaymentStore']);
            Route::get('active', [PaymentTypeController::class, 'active']);
            Route::get('store', [PaymentTypeController::class, 'store']);
            //     Route::get('type/{type}', [PaymentTypeController::class, 'byType']);
            //     Route::patch('{paymentType}/activate', [PaymentTypeController::class, 'activate']);
            //     Route::patch('{paymentType}/deactivate', [PaymentTypeController::class, 'deactivate']);
        });


        Route::prefix('wallets')->group(function () {
            Route::get('transactions', [TransactionController::class, 'fetchTransaction']);
        });
    });
});
